#define vec2 float2
#define vec3 float3
#define vec4 float4
#define rgb xyz
#define rgba xyzw
#define R 0.075f
const sampler_t sampler = CLK_NORMALIZED_COORDS_TRUE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_LINEAR;
const sampler_t sampler1 = CLK_NORMALIZED_COORDS_TRUE | CLK_ADDRESS_REPEAT  | CLK_FILTER_LINEAR;

#define SQRT3 1.732050807
#define PI 3.141592653

__kernel void MAIN(
      __read_only image2d_t input,  
      __read_only image2d_t texture,
      __write_only image2d_t dest_data,
      __global FilterParam* param,
	  int alpha
     ) 
{
    int outputW = param->width[1];
	int outputH = param->height[1];
    int W = get_global_size(0);
	int H = get_global_size(1);
    float2 ouputResolution = (float2)(W,H);  
    int2 gl_FragCoord = (int2)(get_global_id(0), get_global_id(1));

    vec2 fragCoord = (vec2)(get_global_id0( param), get_global_id1( param));
    vec2 resolution = ouputResolution;
	vec2 tc = ((float2)(fragCoord.x, fragCoord.y) + (vec2)(0.5f))/ouputResolution.xy;

    vec2 uv = (float2)(tc.x, tc.y)*(vec2)(param->origROI[2], param->origROI[3]) + (vec2)(param->origROI[0], param->origROI[1]);

    float4 orig = read_imagef(input, sampler, uv);     
    
    float fragX = (float)(get_global_id(0) - get_global_offset(0));
    float fragY = (float)(get_global_id(1) - get_global_offset(1));
    vec2 frag = (vec2)(fragX,fragY);
	vec2 block = floor(frag.xy / (vec2)(16.0f));    
	vec2 uv_noise = block / (vec2)(96.0f);
    float iTime = param->cur_time;
	uv_noise += floor((vec2)(iTime) * (vec2)(1234.0f, 3543.0f)) / (vec2)(96.0f);

    float itpr = 0.0f;	
    vec2 itpr2 = (vec2)(0.0f);
	float block_thresh = pow(fract(iTime * 1236.0453f,&itpr), 2.0f) * 0.2f;
	float line_thresh = pow(fract(iTime * 2236.0453f,&itpr), 3.0f) * 0.7f;
	
	vec2 uv_r = uv, uv_g = uv, uv_b = uv;

	// glitch some blocks and lines
	if (read_imagef(texture,sampler1,uv_noise).x < block_thresh ||
		read_imagef(texture,sampler1,(vec2)(uv_noise.y, 0.0f)).y < line_thresh) {

		vec2 dist = (fract(uv_noise,&itpr2) - 0.5f) * 0.3f;
		uv_r += dist * 0.1f;
		uv_g += dist * 0.2f;
		uv_b += dist * 0.125f;
	}
    vec4 fragColor = orig;
	fragColor.x = read_imagef(input,sampler,uv_r).x;
	fragColor.y = read_imagef(input,sampler,uv_g).y;
	fragColor.z = read_imagef(input,sampler,uv_b).z;

    // fragColor = read_imagef(texture,sampler1,uv_noise);

	// loose luma for some blocks
	if (read_imagef(texture,sampler1,uv_noise).y < block_thresh)
		fragColor.xyz = (vec3)(fragColor.y);

	// discolor block lines
	if (read_imagef(texture,sampler1,(vec2)(uv_noise.y, 0.0f)).x * 3.5f < line_thresh)
		fragColor.xyz = (vec3)(0.0f, dot(fragColor.xyz, (vec3)(1.0f)), 0.0f);

	// interleave lines in some blocks
	if (read_imagef(texture,sampler1,uv_noise).y * 1.5f < block_thresh ||
		read_imagef(texture,sampler1,(vec2)(uv_noise.y, 0.0f)).y * 2.5f < line_thresh) {
		float line = fract(fragCoord.y / 3.0f,&itpr);
		vec3 mask = (vec3)(3.0f, 0.0f, 0.0f);
		if (line > 0.333f)
			mask = (vec3)(0.0f, 3.0f, 0.0f);
		if (line > 0.666f)
			mask = (vec3)(0.0f, 0.0f, 3.0f);
		
		fragColor.xyz *= mask;
	}

    vec4 retColor =  mix( fragColor, orig, 1.0f - (float)(alpha)/100.0f ); 
    write_imagef(dest_data,gl_FragCoord,retColor);
}



